{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Obtained on behalf of Borland through:                                  }
{  Joint Endeavour of Delphi Innovators (JEDI)                            }
{  Website: http://www.delphi-jedi.org                                    }
{  Translator: Rudolph Velthuis                                           }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.UrlMon platform;

{$WEAKPACKAGEUNIT}

interface

uses System.Runtime.InteropServices, System.Text, Windows, ActiveX;

const
  SZ_URLCONTEXT   = 'URL Context';
  SZ_ASYNC_CALLEE = 'AsyncCallee';

  MKSYS_URLMONIKER = 6;

const
  // GUIDs for interfaces declared in this unit

  IID_IPersistMoniker{:       TGUID} = '{79eac9c9-baf9-11ce-8c82-00aa004ba90b}';
  IID_IBinding{:              TGUID} = '{79eac9c0-baf9-11ce-8c82-00aa004ba90b}';
  IID_IBindStatusCallback{:   TGUID} = '{79eac9c1-baf9-11ce-8c82-00aa004ba90b}';
  IID_IAuthenticate{:         TGUID} = '{79eac9d0-baf9-11ce-8c82-00aa004ba90b}';
  IID_IHttpNegotiate{:        TGUID} = '{79eac9d2-baf9-11ce-8c82-00aa004ba90b}';
  IID_IWindowForBindingUI{:   TGUID} = '{79eac9d5-bafa-11ce-8c82-00aa004ba90b}';
  IID_ICodeInstall{:          TGUID} = '{79eac9d1-baf9-11ce-8c82-00aa004ba90b}';
  IID_IWinInetInfo{:          TGUID} = '{79eac9d6-bafa-11ce-8c82-00aa004ba90b}';
  IID_IHttpSecurity{:         TGUID} = '{79eac9d7-bafa-11ce-8c82-00aa004ba90b}';
  IID_IWinInetHttpInfo{:      TGUID} = '{79eac9d8-bafa-11ce-8c82-00aa004ba90b}';

  IID_IBindHost{:             TGUID} = '{fc4801a1-2ba9-11cf-a229-00aa003d7352}';

  IID_IInternet{:             TGUID} = '{79eac9e0-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetBindInfo{:     TGUID} = '{79eac9e1-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetProtocolRoot{: TGUID} = '{79eac9e3-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetProtocol{:     TGUID} = '{79eac9e4-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetProtocolSink{: TGUID} = '{79eac9e5-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetSession{:      TGUID} = '{79eac9e7-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetThreadSwitch{: TGUID} = '{79eac9e8-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetPriority{:     TGUID} = '{79eac9eb-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetProtocolInfo{: TGUID} = '{79eac9ec-baf9-11ce-8c82-00aa004ba90b}';

  SID_IBindHost{:             TGUID} = '{fc4801a1-2ba9-11cf-a229-00aa003d7352}';
  SID_SBindHost{:             TGUID} = '{fc4801a1-2ba9-11cf-a229-00aa003d7352}';

  IID_IOInet{:                TGUID} = '{79eac9e0-baf9-11ce-8c82-00aa004ba90b}';
  IID_IOInetBindInfo{:        TGUID} = '{79eac9e1-baf9-11ce-8c82-00aa004ba90b}';
  IID_IOInetProtocolRoot{:    TGUID} = '{79eac9e3-baf9-11ce-8c82-00aa004ba90b}';
  IID_IOInetProtocol{:        TGUID} = '{79eac9e4-baf9-11ce-8c82-00aa004ba90b}';
  IID_IOInetProtocolSink{:    TGUID} = '{79eac9e5-baf9-11ce-8c82-00aa004ba90b}';
  IID_IOInetProtocolInfo{:    TGUID} = '{79eac9ec-baf9-11ce-8c82-00aa004ba90b}';
  IID_IOInetSession{:         TGUID} = '{79eac9e7-baf9-11ce-8c82-00aa004ba90b}';
  IID_IOInetPriority{:        TGUID} = '{79eac9eb-baf9-11ce-8c82-00aa004ba90b}';
  IID_IOInetThreadSwitch{:    TGUID} = '{79eac9e8-baf9-11ce-8c82-00aa004ba90b}';

  IID_IInternetSecurityMgrSite{:     TGUID} = '{79eac9ed-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetSecurityManager{:     TGUID} = '{79eac9ee-baf9-11ce-8c82-00aa004ba90b}';
  IID_IInternetHostSecurityManager{: TGUID} = '{3af280b6-cb3f-11d0-891e-00c04fb6bfc4}';

  // This service is used for delegation support on the Security Manager interface
  SID_IInternetSecurityManager{:     TGUID} = '{79eac9ee-baf9-11ce-8c82-00aa004ba90b}';
  SID_IInternetHostSecurityManager{: TGUID} = '{3af280b6-cb3f-11d0-891e-00c04fb6bfc4}';

  IID_IInternetZoneManager{:   TGUID} = '{79eac9ef-baf9-11ce-8c82-00aa004ba90b}';

  IID_ISoftDistExt{:           TGUID} = '{B15B8DC1-C7E1-11d0-8680-00AA00BDCB71}';
  IID_IDataFilter{:            TGUID} = '{69d14c80-c18e-11d0-a9ce-006097942311}';
  IID_IEncodingFilterFactory{: TGUID} = '{70bdde00-c18e-11d0-a9ce-006097942311}';

// Originally (in the .h) these were enumeration types
type
  TBindVerb = ULONG;
  TBindInfoF = ULONG;
  TBindF = ULONG;
  TBSCF = ULONG;
  TBindStatus = ULONG;
  TCIPStatus = ULONG;
  TBindString = ULONG;
  TPiFlags = ULONG;
  TOIBdgFlags = ULONG;
  TParseAction = ULONG;
  TPSUAction = ULONG;
  TQueryOption = ULONG;
  TPUAF = ULONG;
  TSZMFlags = ULONG;
  TUrlZone = ULONG;
  TUrlTemplate = ULONG;
  TZAFlags = ULONG;
  TUrlZoneReg = ULONG;

const
  // URLMON-specific defines for UrlMkSetSessionOption
  URLMON_OPTION_USERAGENT         = $10000001;
  URLMON_OPTION_USERAGENT_REFRESH = $10000002;

  CF_NULL = 0;

  CFSTR_MIME_NULL        = 0;
  CFSTR_MIME_TEXT        = 'text/plain';
  CFSTR_MIME_RICHTEXT    = 'text/richtext';
  CFSTR_MIME_X_BITMAP    = 'image/x-xbitmap';
  CFSTR_MIME_POSTSCRIPT  = 'application/postscript';
  CFSTR_MIME_AIFF        = 'audio/aiff';
  CFSTR_MIME_BASICAUDIO  = 'audio/basic';
  CFSTR_MIME_WAV         = 'audio/wav';
  CFSTR_MIME_X_WAV       = 'audio/x-wav';
  CFSTR_MIME_GIF         = 'image/gif';
  CFSTR_MIME_PJPEG       = 'image/pjpeg';
  CFSTR_MIME_JPEG        = 'image/jpeg';
  CFSTR_MIME_TIFF        = 'image/tiff';
  CFSTR_MIME_X_PNG       = 'image/x-png';
  CFSTR_MIME_BMP         = 'image/bmp';
  CFSTR_MIME_X_ART       = 'image/x-jg';
  CFSTR_MIME_X_EMF       = 'image/x-emf';
  CFSTR_MIME_X_WMF       = 'image/x-wmf';
  CFSTR_MIME_AVI         = 'video/avi';
  CFSTR_MIME_MPEG        = 'video/mpeg';
  CFSTR_MIME_FRACTALS    = 'application/fractals';
  CFSTR_MIME_RAWDATA     = 'application/octet-stream';
  CFSTR_MIME_RAWDATASTRM = 'application/octet-stream';
  CFSTR_MIME_PDF         = 'application/pdf';
  CFSTR_MIME_X_AIFF      = 'audio/x-aiff';
  CFSTR_MIME_X_REALAUDIO = 'audio/x-pn-realaudio';
  CFSTR_MIME_XBM         = 'image/xbm';
  CFSTR_MIME_QUICKTIME   = 'video/quicktime';
  CFSTR_MIME_X_MSVIDEO   = 'video/x-msvideo';
  CFSTR_MIME_X_SGI_MOVIE = 'video/x-sgi-movie';
  CFSTR_MIME_HTML        = 'text/html';

// MessageId: MK_S_ASYNCHRONOUS
// MessageText: Operation is successful, but will complete asynchronously.

  MK_S_ASYNCHRONOUS = $000401E8;
  S_ASYNCHRONOUS    = MK_S_ASYNCHRONOUS;

  E_PENDING = $8000000A;

// WinINet and protocol specific errors are mapped to one of the following
// error which are returned in IBSC.OnStopBinding
//
// Note: FACILITY C is split into ranges of 1k
// C0000 - C03FF  INET_E_ (URLMON's original hresult)
// C0400 - C07FF  INET_E_CLIENT_xxx
// C0800 - C0BFF  INET_E_SERVER_xxx
// C0C00 - C0FFF  INET_E_????
// C1000 - C13FF  INET_E_AGENT_xxx (info delivery agents)

// $$$ Original Borland translation:
// INET_E_INVALID_URL: HResult = $800C0002;
// This is not a direct copy of the .h

const
  INET_E_INVALID_URL                 = HResult($800C0002);
  INET_E_NO_SESSION                  = HResult($800C0003);
  INET_E_CANNOT_CONNECT              = HResult($800C0004);
  INET_E_RESOURCE_NOT_FOUND          = HResult($800C0005);
  INET_E_OBJECT_NOT_FOUND            = HResult($800C0006);
  INET_E_DATA_NOT_AVAILABLE          = HResult($800C0007);
  INET_E_DOWNLOAD_FAILURE            = HResult($800C0008);
  INET_E_AUTHENTICATION_REQUIRED     = HResult($800C0009);
  INET_E_NO_VALID_MEDIA              = HResult($800C000A);
  INET_E_CONNECTION_TIMEOUT          = HResult($800C000B);
  INET_E_INVALID_REQUEST             = HResult($800C000C);
  INET_E_UNKNOWN_PROTOCOL            = HResult($800C000D);
  INET_E_SECURITY_PROBLEM            = HResult($800C000E);
  INET_E_CANNOT_LOAD_DATA            = HResult($800C000F);
  INET_E_CANNOT_INSTANTIATE_OBJECT   = HResult($800C0010);
  INET_E_REDIRECT_FAILED             = HResult($800C0014);
  INET_E_REDIRECT_TO_DIR             = HResult($800C0015);
  INET_E_CANNOT_LOCK_REQUEST         = HResult($800C0016);
  INET_E_ERROR_FIRST                 = HResult($800C0002);
  INET_E_ERROR_LAST                  = INET_E_REDIRECT_TO_DIR;

type
  IBinding = ActiveX.IBinding;

  [ComImport,
  GuidAttribute('79eac9c9-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersistMoniker = interface
    [PreserveSig]
    function GetClassID(out ClassID: TCLSID): HResult;
    [PreserveSig]
    function IsDirty: HResult;
    [PreserveSig]
    function Load(fFullyAvailable: BOOL; pimkName: IMoniker; pibc: IBindCtx;
      grfMode: DWORD): HResult;
    [PreserveSig]
    function Save(pimkName: IMoniker; pbc: IBindCtx; fRemember: BOOL): HResult;
    [PreserveSig]
    function SaveCompleted(pimkName: IMoniker; pibc: IBindCtx): HResult;
    [PreserveSig]
    function GetCurMoniker(ppimkName: IMoniker): HResult;
   end;

  [ComImport,
  GuidAttribute('79eac9cd-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IBindProtocol = interface
    [PreserveSig]
    function CreateBinding([MarshalAs(UnmanagedType.LPWStr)] szUrl: string;
      pbc: IBindCtx; out ppb: IBinding): HResult;
  end;

const
  BINDVERB_GET    = $00000000;
  BINDVERB_POST   = $00000001;
  BINDVERB_PUT    = $00000002;
  BINDVERB_CUSTOM = $00000003;

  BINDINFOF_URLENCODESTGMEDDATA  = $00000001;
  BINDINFOF_URLENCODEDEXTRAINFO  = $00000002;

  BINDF_ASYNCHRONOUS             = $00000001;
  BINDF_ASYNCSTORAGE             = $00000002;
  BINDF_NOPROGRESSIVERENDERING   = $00000004;
  BINDF_OFFLINEOPERATION         = $00000008;
  BINDF_GETNEWESTVERSION         = $00000010;
  BINDF_NOWRITECACHE             = $00000020;
  BINDF_NEEDFILE                 = $00000040;
  BINDF_PULLDATA                 = $00000080;
  BINDF_IGNORESECURITYPROBLEM    = $00000100;
  BINDF_RESYNCHRONIZE            = $00000200;
  BINDF_HYPERLINK                = $00000400;
  BINDF_NO_UI                    = $00000800;
  BINDF_SILENTOPERATION          = $00001000;
  BINDF_PRAGMA_NO_CACHE          = $00002000;
  BINDF_FREE_THREADED            = $00010000;
  BINDF_DIRECT_READ              = $00020000;
  BINDF_FORMS_SUBMIT             = $00040000;
  BINDF_GETFROMCACHE_IF_NET_FAIL = $00080000;
  
  // These are for backwards compatibility with previous URLMON versions 
  BINDF_DONTUSECACHE             = BINDF_GETNEWESTVERSION;
  BINDF_DONTPUTINCACHE           = BINDF_NOWRITECACHE;
  BINDF_NOCOPYDATA               = BINDF_PULLDATA;

  BSCF_FIRSTDATANOTIFICATION        = $00000001;
  BSCF_INTERMEDIATEDATANOTIFICATION = $00000002;
  BSCF_LASTDATANOTIFICATION         = $00000004;
  BSCF_DATAFULLYAVAILABLE           = $00000008;
  BSCF_AVAILABLEDATASIZEUNKNOWN     = $00000010;

  BINDSTATUS_FINDINGRESOURCE           = 1;
  BINDSTATUS_CONNECTING                = BINDSTATUS_FINDINGRESOURCE + 1;
  BINDSTATUS_REDIRECTING               = BINDSTATUS_CONNECTING + 1;
  BINDSTATUS_BEGINDOWNLOADDATA         = BINDSTATUS_REDIRECTING + 1;
  BINDSTATUS_DOWNLOADINGDATA           = BINDSTATUS_BEGINDOWNLOADDATA + 1;
  BINDSTATUS_ENDDOWNLOADDATA           = BINDSTATUS_DOWNLOADINGDATA + 1;
  BINDSTATUS_BEGINDOWNLOADCOMPONENTS   = BINDSTATUS_ENDDOWNLOADDATA + 1;
  BINDSTATUS_INSTALLINGCOMPONENTS      = BINDSTATUS_BEGINDOWNLOADCOMPONENTS + 1;
  BINDSTATUS_ENDDOWNLOADCOMPONENTS     = BINDSTATUS_INSTALLINGCOMPONENTS + 1;
  BINDSTATUS_USINGCACHEDCOPY           = BINDSTATUS_ENDDOWNLOADCOMPONENTS + 1;
  BINDSTATUS_SENDINGREQUEST            = BINDSTATUS_USINGCACHEDCOPY + 1;
  BINDSTATUS_CLASSIDAVAILABLE          = BINDSTATUS_SENDINGREQUEST + 1;
  BINDSTATUS_MIMETYPEAVAILABLE         = BINDSTATUS_CLASSIDAVAILABLE + 1;
  BINDSTATUS_CACHEFILENAMEAVAILABLE    = BINDSTATUS_MIMETYPEAVAILABLE + 1;
  BINDSTATUS_BEGINSYNCOPERATION        = BINDSTATUS_CACHEFILENAMEAVAILABLE + 1;
  BINDSTATUS_ENDSYNCOPERATION          = BINDSTATUS_BEGINSYNCOPERATION + 1;
  BINDSTATUS_BEGINUPLOADDATA           = BINDSTATUS_ENDSYNCOPERATION + 1;
  BINDSTATUS_UPLOADINGDATA             = BINDSTATUS_BEGINUPLOADDATA + 1;
  BINDSTATUS_ENDUPLOADDATA             = BINDSTATUS_UPLOADINGDATA + 1;
  BINDSTATUS_PROTOCOLCLASSID           = BINDSTATUS_ENDUPLOADDATA + 1;
  BINDSTATUS_ENCODING                  = BINDSTATUS_PROTOCOLCLASSID + 1;
  BINDSTATUS_VERIFIEDMIMETYPEAVAILABLE = BINDSTATUS_ENCODING + 1;
  BINDSTATUS_CLASSINSTALLLOCATION      = BINDSTATUS_VERIFIEDMIMETYPEAVAILABLE + 1;
  BINDSTATUS_DECODING                  = BINDSTATUS_CLASSINSTALLLOCATION + 1;
  BINDSTATUS_LOADINGMIMEHANDLER        = BINDSTATUS_DECODING + 1;
  BINDSTATUS_CONTENTDISPOSITIONATTACH = BINDSTATUS_LOADINGMIMEHANDLER + 1;
  BINDSTATUS_FILTERREPORTMIMETYPE = BINDSTATUS_CONTENTDISPOSITIONATTACH + 1;
  BINDSTATUS_CLSIDCANINSTANTIATE = BINDSTATUS_FILTERREPORTMIMETYPE + 1;
  BINDSTATUS_IUNKNOWNAVAILABLE = BINDSTATUS_CLSIDCANINSTANTIATE + 1;
  BINDSTATUS_DIRECTBIND = BINDSTATUS_IUNKNOWNAVAILABLE + 1;
  BINDSTATUS_RAWMIMETYPE = BINDSTATUS_DIRECTBIND + 1;
  BINDSTATUS_PROXYDETECTING = BINDSTATUS_RAWMIMETYPE + 1;
  BINDSTATUS_ACCEPTRANGES = BINDSTATUS_PROXYDETECTING + 1;
  BINDSTATUS_COOKIE_SENT = BINDSTATUS_ACCEPTRANGES + 1;
  BINDSTATUS_COMPACT_POLICY_RECEIVED      = BINDSTATUS_COOKIE_SENT + 1;
  BINDSTATUS_COOKIE_SUPPRESSED = BINDSTATUS_COMPACT_POLICY_RECEIVED + 1;
  BINDSTATUS_COOKIE_STATE_UNKNOWN = BINDSTATUS_COOKIE_SUPPRESSED + 1;
  BINDSTATUS_COOKIE_STATE_ACCEPT = BINDSTATUS_COOKIE_STATE_UNKNOWN + 1;
  BINDSTATUS_COOKIE_STATE_REJECT = BINDSTATUS_COOKIE_STATE_ACCEPT + 1;
  BINDSTATUS_COOKIE_STATE_PROMPT = BINDSTATUS_COOKIE_STATE_REJECT + 1;
  BINDSTATUS_COOKIE_STATE_LEASH = BINDSTATUS_COOKIE_STATE_PROMPT + 1;
  BINDSTATUS_COOKIE_STATE_DOWNGRADE = BINDSTATUS_COOKIE_STATE_LEASH + 1;
  BINDSTATUS_POLICY_HREF = BINDSTATUS_COOKIE_STATE_DOWNGRADE + 1;
  BINDSTATUS_P3P_HEADER = BINDSTATUS_POLICY_HREF + 1;
  BINDSTATUS_SESSION_COOKIE_RECEIVED = BINDSTATUS_P3P_HEADER + 1;
  BINDSTATUS_PERSISTENT_COOKIE_RECEIVED = BINDSTATUS_SESSION_COOKIE_RECEIVED + 1;
  BINDSTATUS_SESSION_COOKIES_ALLOWED = BINDSTATUS_PERSISTENT_COOKIE_RECEIVED + 1;

type
  TBindInfo = ActiveX.TBindInfo;
  
  _REMSECURITY_ATTRIBUTES = packed record
    nLength: DWORD;
    lpSecurityDescriptor: DWORD;
    bInheritHandle: BOOL;
  end;
  TRemSecurityAttributes = _REMSECURITY_ATTRIBUTES;
  REMSECURITY_ATTRIBUTES = _REMSECURITY_ATTRIBUTES;

  _tagRemBINDINFO = packed record
    cbSize: ULONG;
    [MarshalAs(UnmanagedType.LPWStr)]
    szExtraInfo: string;
    grfBindInfoF: DWORD;
    dwBindVerb: DWORD;
    [MarshalAs(UnmanagedType.LPWStr)]
    szCustomVerb: string;
    cbstgmedData: DWORD;
    dwOptions: DWORD;
    dwOptionsFlags: DWORD;
    dwCodePage: DWORD;
    securityAttributes: TRemSecurityAttributes;
    iid: TGUID;
    [MarshalAs(UnmanagedType.IUnknown)]
    pUnk: TObject;
    dwReserved: DWORD;
  end;
  TRemBindInfo = _tagRemBINDINFO; 
  RemBINDINFO = _tagRemBINDINFO;
  
  tagRemFORMATETC = packed record
    cfFormat: DWORD;
    ptd: DWORD;
    dwAspect: DWORD;
    lindex: Longint;
    tymed: DWORD;
  end;
  TRemFormatEtc = tagRemFORMATETC;
  RemFORMATETC = tagRemFORMATETC;

  IBindStatusCallback = ActiveX.IBindStatusCallback;

  [ComImport,
  GuidAttribute('79eac9d0-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAuthenticate = interface
    [PreserveSig]
    function Authenticate(var hwnd: HWnd;
      [MarshalAs(UnmanagedType.LPWStr)] var szUserName, szPassWord: string): HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9d2-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IHttpNegotiate = interface
    [PreserveSig]
    function BeginningTransaction([MarshalAs(UnmanagedType.LPWStr)] szURL, szHeaders: string;
      dwReserved: DWORD; [MarshalAs(UnmanagedType.LPWStr)] out szAdditionalHeaders: string): HResult;
    [PreserveSig]
    function OnResponse(dwResponseCode: DWORD;
      [MarshalAs(UnmanagedType.LPWStr)] szResponseHeaders, szRequestHeaders: string;
      [MarshalAs(UnmanagedType.LPWStr)] out szAdditionalRequestHeaders: string): HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9d5-bafa-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IWindowForBindingUI = interface
    [PreserveSig]
    function GetWindow([in, MarshalAs(UnmanagedType.LPStruct)] guidReason: TGUID;
      out phwnd: HWND): HResult;
  end;

const
  CIP_DISK_FULL                            = 0;
  CIP_ACCESS_DENIED                        = CIP_DISK_FULL + 1;
  CIP_NEWER_VERSION_EXISTS                 = CIP_ACCESS_DENIED + 1;
  CIP_OLDER_VERSION_EXISTS                 = CIP_NEWER_VERSION_EXISTS + 1;
  CIP_NAME_CONFLICT                        = CIP_OLDER_VERSION_EXISTS + 1;
  CIP_TRUST_VERIFICATION_COMPONENT_MISSING = CIP_NAME_CONFLICT + 1;
  CIP_EXE_SELF_REGISTERATION_TIMEOUT       = CIP_TRUST_VERIFICATION_COMPONENT_MISSING + 1;
  CIP_UNSAFE_TO_ABORT                      = CIP_EXE_SELF_REGISTERATION_TIMEOUT + 1;
  CIP_NEED_REBOOT                          = CIP_UNSAFE_TO_ABORT + 1;

type
  [ComImport,
  GuidAttribute('79eac9d1-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICodeInstall = interface { IWindowForBindingUI }
    // IWindowForBindingUI
    [PreserveSig]
    function GetWindow([in, MarshalAs(UnmanagedType.LPStruct)] guidReason: TGUID;
      out phwnd: HWND): HResult;

    // ICodeInstall
    [PreserveSig]
    function OnCodeInstallProblem(ulStatusCode: ULONG;
      [MarshalAs(UnmanagedType.LPWStr)] szDestination, szSource: string;
      dwReserved: DWORD): HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9d6-bafa-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IWinInetInfo = interface
    [PreserveSig]
    function QueryOption(dwOption: DWORD; Buffer: IntPtr; var cbBuf: DWORD): HResult;
  end;

const
  WININETINFO_OPTION_LOCK_HANDLE   = 65534;

type
  [ComImport,
  GuidAttribute('79eac9d7-bafa-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IHttpSecurity = interface { IWindowForBindingUI }
    // IWindowForBindingUI
    [PreserveSig]
    function GetWindow([in, MarshalAs(UnmanagedType.LPStruct)] guidReason: TGUID;
      out phwnd: HWND): HResult;

    // IHttpSecurity
    [PreserveSig]
    function OnSecurityProblem(dwProblem: DWORD): HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9d8-bafa-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IWinInetHttpInfo = interface { IWinInetInfo }
    // IWinInetInfo
    [PreserveSig]
    function QueryOption(dwOption: DWORD; Buffer: IntPtr; var cbBuf: DWORD): HResult;

    // IWinInetHttpInfo
    [PreserveSig]
    function QueryInfo(dwOption: DWORD; Buffer: IntPtr;
      var cbBuf, dwFlags, dwReserved: DWORD): HResult;
  end;

  IBindHost = ActiveX.IBindHost;

const
  URLOSTRM_USECACHEDCOPY_ONLY = $00000001;      // Only get from cache
  URLOSTRM_USECACHEDCOPY      = $00000002;      // Get from cache if available else download
  URLOSTRM_GETNEWESTVERSION   = $00000003;      // Get new version only. But put it in cache too


function HlinkSimpleNavigateToString(
  szTarget,                           // required - target document - null if local jump w/in doc
  szLocation,                         // optional, for navigation into middle of a doc
  szTargetFrameName: string;          // optional, for targeting frame-sets
  [MarshalAs(UnmanagedType.IUnknown)]
  Unk: TObject;                       // required - we'll search this for other necessary interfaces
  pbc: IBindCtx;                      // optional. caller may register an IBSC in this
  BSC: IBindStatusCallback;
  grfHLNF,                            // flags
  dwReserved: DWORD): HResult;

function HlinkSimpleNavigateToMoniker(
  mkTarget: Imoniker;                 // required - target document - (may be null
  szLocation,                         // optional, for navigation into middle of a doc
  szTargetFrameName: string;          // optional, for targeting frame-sets
  [MarshalAs(UnmanagedType.IUnknown)]
  Unk: TObject;                       // required - we'll search this for other necessary interfaces
  bc: IBindCtx;                       // optional. caller may register an IBSC in this
  BSC: IBindStatusCallback;
  grfHLNF,                            // flags
  dwReserved: DWORD): HResult;

function CreateURLMoniker(MkCtx: IMoniker; szURL: string; out mk: IMoniker): HResult;
function GetClassURL(szURL: string;
  [in, MarshalAs(UnmanagedType.LPStruct)] ClsID: TCLSID): HResult;
function CreateAsyncBindCtx(reserved: DWORD; pBSCb: IBindStatusCallback;
  pEFetc: IEnumFORMATETC; out ppBC: IBindCtx): HResult;
function CreateAsyncBindCtxEx(pbc: IBindCtx; dwOptions: DWORD; BSCb: IBindStatusCallback;
  Enum: IEnumFORMATETC; out ppBC: IBindCtx; reserved: DWORD): HResult;
function MkParseDisplayNameEx(pbc: IBindCtx; szDisplayName: string;
  out pchEaten: ULONG; out ppmk: IMoniker): HResult;
function RegisterBindStatusCallback(pBC: IBindCtx; pBSCb: IBindStatusCallback;
  out ppBSCBPrev: IBindStatusCallback; dwReserved: DWORD): HResult;
function RevokeBindStatusCallback(pBC: IBindCtx; pBSCb: IBindStatusCallback): HResult;
function GetClassFileOrMime(pBC: IBindCtx; szFilename: string; pBuffer: IntPtr;
  cbSize: DWORD; szMime: string; dwReserved: DWORD; out pclsid: TCLSID): HResult;
function IsValidURL(pBC: IBindCtx; szURL: string; dwReserved: DWORD): HResult;
function CoGetClassObjectFromURL([in, MarshalAs(UnmanagedType.LPStruct)] rCLASSID: TCLSID;
  szCODE: string; dwFileVersionMS, dwFileVersionLS: DWORD; szTYPE: string;
  pBindCtx: IBindCtx; dwClsContext: DWORD; pvReserved: IntPtr;
  [in, MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
  [in, MarshalAs(UnmanagedType.Interface)] out ppv): HResult;

//helper apis
function IsAsyncMoniker(pmk: IMoniker): HResult;
function CreateURLBinding(lpszUrl: string; pbc: IBindCtx; out ppBdg: IBinding): HResult;

function RegisterMediaTypes(ctypes: UINT;
  [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr)]
  rgszTypes: array of string;
  [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex=0)]
  rgcfTypes: array of TClipFormat): HResult;
function FindMediaType(rgszTypes: string; var rgcfTypes: TClipFormat): HResult;
function CreateFormatEnumerator(cfmtetc: UINT;
  [in, MarshalAs(UnmanagedType.LPArray)] rgfmtetc: array of TFormatEtc;
  out ppenumfmtetc: IEnumFormatEtc): HResult;
function RegisterFormatEnumerator(pBC: IBindCtx; pEFetc: IEnumFormatEtc; reserved: DWORD): HResult;
function RevokeFormatEnumerator(pBC: IBindCtx; pEFetc: IEnumFormatEtc): HResult;
function RegisterMediaTypeClass(pBC: IBindCtx; ctypes: UINT;
  [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr)]
  rgszTypes: array of string;
  [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPStruct, SizeParamIndex=1)]
  rgclsID: array of TCLSID; reserved: DWORD): HResult;
function FindMediaTypeClass(pBC: IBindCtx; szType: string;
  [in, MarshalAs(UnmanagedType.LPStruct)] pclsID: TCLSID; reserved: DWORD): HResult;
function UrlMkSetSessionOption(dwOption: DWORD; pBuffer: IntPtr; dwBufferLength, dwReserved: DWORD): HResult;
function UrlMkGetSessionOption(dwOption: DWORD; pBuffer: IntPtr; dwBufferLength: DWORD; out pdwBufferLength: DWORD; dwReserved: DWORD): HResult;
function FindMimeFromData(
    pBC: IBindCtx;                      // bind context - can be nil
    pwzUrl: string;                     // url - can be nil
    pBuffer: IntPtr;                    // buffer with data to sniff - can be nil (pwzUrl must be valid)
    cbSize: DWORD;                      // size of buffer
    pwzMimeProposed: string;            // proposed mime if - can be nil
    dwMimeFlags: DWORD;                 // will be defined
    [MarshalAs(UnmanagedType.LPWStr)]
    out ppwzMimeOut: string;            // the suggested mime
    dwReserved: DWORD                   // must be 0
  ): HResult;
function ObtainUserAgentString(dwOption: DWORD; pszUAOut: string; var cbSize: DWORD): HResult;

function URLOpenStream([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: DWORD; p4: IBindStatusCallback): HResult;
function URLOpenStreamA([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: DWORD; p4: IBindStatusCallback): HResult;
function URLOpenStreamW([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: DWORD; p4: IBindStatusCallback): HResult;
function URLOpenPullStream([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: DWORD; BSC: IBindStatusCallback): HResult;
function URLOpenPullStreamA([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: DWORD; BSC: IBindStatusCallback): HResult;
function URLOpenPullStreamW([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: DWORD; BSC: IBindStatusCallback): HResult;
function URLDownloadToFile([in, MarshalAs(UnmanagedType.IUnknown)] Caller: TObject;
  URL: string; FileName: string; Reserved: DWORD; StatusCB: IBindStatusCallback): HResult;
function URLDownloadToFileA([in, MarshalAs(UnmanagedType.IUnknown)] Caller: TObject;
  URL: string; FileName: string; Reserved: DWORD; StatusCB: IBindStatusCallback): HResult;
function URLDownloadToFileW([in, MarshalAs(UnmanagedType.IUnknown)] Caller: TObject;
  URL: string; FileName: string; Reserved: DWORD; StatusCB: IBindStatusCallback): HResult;
function URLDownloadToCacheFile([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: string; p4: DWORD; p5: DWORD; p6: IBindStatusCallback): HResult;
function URLDownloadToCacheFileA([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: string; p4: DWORD; p5: DWORD; p6: IBindStatusCallback): HResult;
function URLDownloadToCacheFileW([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; p3: string; p4: DWORD; p5: DWORD; p6: IBindStatusCallback): HResult;
function URLOpenBlockingStream([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; out p3: IStream; p4: DWORD; p5: IBindStatusCallback): HResult;
function URLOpenBlockingStreamA([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; out p3: IStream; p4: DWORD; p5: IBindStatusCallback): HResult;
function URLOpenBlockingStreamW([in, MarshalAs(UnmanagedType.IUnknown)] p1: TObject;
  p2: string; out p3: IStream; p4: DWORD; p5: IBindStatusCallback): HResult;

function HlinkGoBack([in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject): HResult;
function HlinkGoForward([in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject): HResult;
function HlinkNavigateString([in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  szTarget: string): HResult;
function HlinkNavigateMoniker([in, MarshalAs(UnmanagedType.IUnknown)] unk: TObject;
  mkTarget: IMoniker): HResult;

type
  [ComImport,
  GuidAttribute('79eac9e0-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternet = interface
  end;

const
  BINDSTRING_HEADERS          = 1;
  BINDSTRING_ACCEPT_MIMES     = BINDSTRING_HEADERS + 1;
  BINDSTRING_EXTRA_URL        = BINDSTRING_ACCEPT_MIMES + 1;
  BINDSTRING_LANGUAGE         = BINDSTRING_EXTRA_URL + 1;
  BINDSTRING_USERNAME         = BINDSTRING_LANGUAGE + 1;
  BINDSTRING_PASSWORD         = BINDSTRING_USERNAME + 1;
  BINDSTRING_UA_PIXELS        = BINDSTRING_PASSWORD + 1;
  BINDSTRING_UA_COLOR         = BINDSTRING_UA_PIXELS + 1;
  BINDSTRING_OS               = BINDSTRING_UA_COLOR + 1;
  BINDSTRING_USER_AGENT       = BINDSTRING_OS + 1;
  BINDSTRING_ACCEPT_ENCODINGS = BINDSTRING_USER_AGENT + 1;
  BINDSTRING_POST_COOKIE      = BINDSTRING_ACCEPT_ENCODINGS + 1;
  BINDSTRING_POST_DATA_MIME   = BINDSTRING_POST_COOKIE + 1;
  BINDSTRING_URL              = BINDSTRING_POST_DATA_MIME + 1;

type
  [ComImport,
  GuidAttribute('79eac9e1-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetBindInfo = interface
    [PreserveSig]
    function GetBindInfo(out grfBINDF: DWORD; var bindinfo: TBindInfo): HResult;
    [PreserveSig]
    function GetBindString(ulStringType: ULONG;
      [in, out, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr, SizeParamIndex = 3)]
      wzStr: array of string; cEl: ULONG; var cElFetched: ULONG): HResult;
  end;

const
  PI_PARSE_URL                = $00000001;
  PI_FILTER_MODE              = $00000002;
  PI_FORCE_ASYNC              = $00000004;
  PI_USE_WORKERTHREAD         = $00000008;
  PI_MIMEVERIFICATION         = $00000010;
  PI_CLSIDLOOKUP              = $00000020;
  PI_DATAPROGRESS             = $00000040;
  PI_SYNCHRONOUS              = $00000080;
  PI_APARTMENTTHREADED        = $00000100;
  PI_CLASSINSTALL             = $00000200;
  PD_FORCE_SWITCH             = $00010000;

  PI_DOCFILECLSIDLOOKUP       = PI_CLSIDLOOKUP;

type
  _tagPROTOCOLDATA = packed record
    grfFlags: DWORD;
    dwState: DWORD;
    pData: IntPtr; { Pointer }
    cbData: ULONG;
  end;
  TProtocolData = _tagPROTOCOLDATA;
  PROTOCOLDATA = _tagPROTOCOLDATA;

  IInternetProtocolSink = interface; // forward

  [ComImport,
  GuidAttribute('79eac9e3-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetProtocolRoot = interface
    [PreserveSig]
    function Start(szUrl: string; OIProtSink: IInternetProtocolSink;
      OIBindInfo: IInternetBindInfo; grfPI, dwReserved: DWORD): HResult;
    [PreserveSig]
    function Continue([in] var ProtocolData: TProtocolData): HResult;
    [PreserveSig]
    function Abort(hrReason: HResult; dwOptions: DWORD): HResult;
    [PreserveSig]
    function Terminate(dwOptions: DWORD): HResult;
    [PreserveSig]
    function Suspend: HResult;
    [PreserveSig]
    function Resume: HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9e4-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetProtocol = interface { IInternetProtocolRoot }
    // IInternetProtocolRoot
    [PreserveSig]
    function Start(szUrl: string; OIProtSink: IInternetProtocolSink;
      OIBindInfo: IInternetBindInfo; grfPI, dwReserved: DWORD): HResult;
    [PreserveSig]
    function Continue([in] var ProtocolData: TProtocolData): HResult;
    [PreserveSig]
    function Abort(hrReason: HResult; dwOptions: DWORD): HResult;
    [PreserveSig]
    function Terminate(dwOptions: DWORD): HResult;
    [PreserveSig]
    function Suspend: HResult;
    [PreserveSig]
    function Resume: HResult;

    // IInternetProtocol
    [PreserveSig]
    function Read([out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 1)]
      pv: TBytes; cb: ULONG; out cbRead: ULONG): HResult;
    [PreserveSig]
    function Seek(dlibMove: LARGE_INTEGER; dwOrigin: DWORD; out libNewPosition: ULARGE_INTEGER): HResult;
    [PreserveSig]
    function LockRequest(dwOptions: DWORD): HResult;
    [PreserveSig]
    function UnlockRequest: HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9e5-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetProtocolSink = interface
    [PreserveSig]
    function Switch([in] var ProtocolData: TProtocolData): HResult;
    [PreserveSig]
    function ReportProgress(ulStatusCode: ULONG; szStatusText: string): HResult;
    [PreserveSig]
    function ReportData(grfBSCF: DWORD; ulProgress, ulProgressMax: ULONG): HResult;
    [PreserveSig]
    function ReportResult(hrResult: HResult; dwError: DWORD; szResult: string): HResult;
  end;

const
  OIBDG_APARTMENTTHREADED     = $00000100;

type
  [ComImport,
  GuidAttribute('79eac9e7-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetSession = interface
    [PreserveSig]
    function RegisterNameSpace(CF: IClassFactory;
      [in, MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
      pwzProtocol: string; cPatterns: ULONG;
      [in, MarshalAs(UnmanagedType.LPArray, ArraySubType=UnmanagedType.LPWStr, SizeParamIndex = 3)]
      pwzPatterns: array of string; dwReserved: DWORD): HResult;
    [PreserveSig]
    function UnregisterNameSpace(CF: IClassFactory; pszProtocol: string): HResult;
    [PreserveSig]
    function RegisterMimeFilter(CF: IClassFactory;
      [in, MarshalAs(UnmanagedType.LPStruct)] rclsid: TCLSID; pwzType: string): HResult;
    [PreserveSig]
    function UnregisterMimeFilter(CF: IClassFactory; pwzType: string): HResult;
    [PreserveSig]
    function CreateBinding(BC: IBindCtx; szUrl: string;
      [in, MarshalAs(UnmanagedType.IUnknown)] UnkOuter: TObject;
      [MarshalAs(UnmanagedType.IUnknown)] out Unk: TObject;
      out OINetProt: IInternetProtocol; dwOption: DWORD): HResult;
    [PreserveSig]
    function SetSessionOption(dwOption: DWORD; pBuffer: IntPtr; dwBufferLength: DWORD;
      dwReserved: DWORD): HResult;
    [PreserveSig]
    function GetSessionOption(dwOption: DWORD; pBuffer: IntPtr; var dwBufferLength: DWORD;
      dwReserved: DWORD): HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9e8-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetThreadSwitch = interface
    [PreserveSig]
    function Prepare: HResult;
    [PreserveSig]
    function Continue: HResult;
  end;

  [ComImport,
  GuidAttribute('79eac9eb-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetPriority = interface
    [PreserveSig]
    function SetPriority(nPriority: Longint): HResult;
    [PreserveSig]
    function GetPriority(out nPriority: Longint): HResult;
  end;

const
  PARSE_CANONICALIZE    = 1;
  PARSE_FRIENDLY        = PARSE_CANONICALIZE + 1;
  PARSE_SECURITY_URL    = PARSE_FRIENDLY + 1;
  PARSE_ROOTDOCUMENT    = PARSE_SECURITY_URL + 1;
  PARSE_DOCUMENT        = PARSE_ROOTDOCUMENT + 1;
  PARSE_ANCHOR          = PARSE_DOCUMENT + 1;
  PARSE_ENCODE          = PARSE_ANCHOR + 1;
  PARSE_DECODE          = PARSE_ENCODE + 1;
  PARSE_PATH_FROM_URL   = PARSE_DECODE + 1;
  PARSE_URL_FROM_PATH   = PARSE_PATH_FROM_URL + 1;
  PARSE_MIME            = PARSE_URL_FROM_PATH + 1;
  PARSE_SERVER          = PARSE_MIME + 1;
  PARSE_SCHEMA          = PARSE_SERVER + 1;
  PARSE_SITE            = PARSE_SCHEMA + 1;
  PARSE_DOMAIN          = PARSE_SITE + 1;
  PARSE_LOCATION        = PARSE_DOMAIN + 1;
  PARSE_SECURITY_DOMAIN = PARSE_LOCATION + 1;

  PSU_DEFAULT           = 1;
  PSU_SECURITY_URL_ONLY = PSU_DEFAULT + 1;

  QUERY_EXPIRATION_DATE     = 1;
  QUERY_TIME_OF_LAST_CHANGE = QUERY_EXPIRATION_DATE + 1;
  QUERY_CONTENT_ENCODING    = QUERY_TIME_OF_LAST_CHANGE + 1;
  QUERY_CONTENT_TYPE        = QUERY_CONTENT_ENCODING + 1;
  QUERY_REFRESH             = QUERY_CONTENT_TYPE + 1;
  QUERY_RECOMBINE           = QUERY_REFRESH + 1;
  QUERY_CAN_NAVIGATE        = QUERY_RECOMBINE + 1;
  QUERY_USES_NETWORK        = QUERY_CAN_NAVIGATE + 1;
  QUERY_IS_CACHED           = QUERY_USES_NETWORK + 1;
  QUERY_IS_INSTALLEDENTRY   = QUERY_IS_CACHED + 1;
  QUERY_IS_CACHED_OR_MAPPED = QUERY_IS_INSTALLEDENTRY + 1;
  QUERY_USES_CACHE          = QUERY_IS_CACHED_OR_MAPPED + 1;
  QUERY_IS_SECURE           = QUERY_USES_CACHE + 1;
  QUERY_IS_SAFE             = QUERY_IS_SECURE + 1;

type
  [ComImport,
  GuidAttribute('79eac9ec-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetProtocolInfo = interface
    [PreserveSig]
    function ParseUrl(pwzUrl: string; ParseAction: TParseAction; dwParseFlags: DWORD;
      pwzResult: StringBuilder; cchResult: DWORD; out pcchResult: DWORD;
      dwReserved: DWORD): HResult;
    [PreserveSig]
    function CombineUrl(pwzBaseUrl, pwzRelativeUrl: string; dwCombineFlags: DWORD;
      pwzResult: StringBuilder; cchResult: DWORD; out pcchResult: DWORD;
      dwReserved: DWORD): HResult;
    [PreserveSig]
    function CompareUrl(pwzUrl1, pwzUrl2: string; dwCompareFlags: DWORD): HResult;
    [PreserveSig]
    function QueryInfo(pwzUrl: string; QueryOption: TQueryOption; dwQueryFlags: DWORD;
      pBuffer: IntPtr; cbBuffer: DWORD; var cbBuf: DWORD; dwReserved: DWORD): HResult;
  end;

type
  IOInet =               IInternet;
  IOInetBindInfo =       IInternetBindInfo;
  IOInetProtocolRoot =   IInternetProtocolRoot;
  IOInetProtocol =       IInternetProtocol;
  IOInetProtocolSink =   IInternetProtocolSink;
  IOInetProtocolInfo =   IInternetProtocolInfo;
  IOInetSession =        IInternetSession;
  IOInetPriority =       IInternetPriority;
  IOInetThreadSwitch =   IInternetThreadSwitch;

function CoInternetParseUrl(pwzUrl: string; ParseAction: TParseAction;
  dwFlags: DWORD; pszResult: StringBuilder; cchResult: DWORD; var pcchResult: DWORD;
  dwReserved: DWORD): HResult;
function CoInternetCombineUrl(pwzBaseUrl, pwzRelativeUrl: string;
  dwCombineFlags: DWORD; pszResult: StringBuilder; cchResult: DWORD;
  var pcchResult: DWORD; dwReserved: DWORD): HResult ;
function CoInternetCompareUrl(pwzUrl1, pwzUrl2: string; dwFlags: DWORD): HResult;
function CoInternetGetProtocolFlags(pwzUrl: string; var dwFlags: DWORD;
  dwReserved: DWORD): HResult;
function CoInternetQueryInfo(pwzUrl: string; QueryOptions: TQueryOption; dwQueryFlags: DWORD;
  pvBuffer: IntPtr; cbBuffer: DWORD; var pcbBuffer: DWORD; dwReserved: DWORD): HResult;
function CoInternetGetSession(dwSessionMode: DWORD; var pIInternetSession: IInternetSession;
  dwReserved: DWORD): HResult;
function CoInternetGetSecurityUrl(pwzUrl: string;
  [MarshalAs(UnmanagedType.LPWStr)] var pwzSecUrl: string;
  psuAction: TPSUAction; dwReserved: DWORD): HResult;

// OInetXXX are synonyms for the previous functions
function OInetParseUrl(pwzUrl: string; ParseAction: TParseAction; dwFlags: DWORD;
  pszResult: StringBuilder; cchResult: DWORD; var pcchResult: DWORD;
  dwReserved: DWORD): HResult;
function OInetCombineUrl(pwzBaseUrl, pwzRelativeUrl: string; dwCombineFlags: DWORD;
  pszResult: StringBuilder; cchResult: DWORD; var pcchResult: DWORD;
  dwReserved: DWORD): HResult ;
function OInetCompareUrl(pwzUrl1, pwzUrl2: string; dwFlags: DWORD): Hresult;
function OInetGetProtocolFlags(pwzUrl: string; var dwFlags: DWORD;
  dwReserved: DWORD): HResult;
function OInetQueryInfo(pwzUrl: string; QueryOptions: TQueryOption; dwQueryFlags: DWORD;
  pvBuffer: IntPtr; cbBuffer: DWORD; var pcbBuffer: DWORD; dwReserved: DWORD): HResult;
function OInetGetSession(dwSessionMode: DWORD; var pIInternetSession: IInternetSession;
  dwReserved: DWORD): HResult;
function OInetGetSecurityUrl(pwzUrl: string;
  [MarshalAs(UnmanagedType.LPWStr)] var pwzSecUrl: string;
  psuAction: TPSUAction; dwReserved: DWORD): HResult;

function CopyStgMedium(const cstgmedSrc: TStgMedium; var stgmedDest: TStgMedium): HResult;
function CopyBindInfo(const cbiSrc: TBindInfo; var biDest: TBindInfo): HResult;
procedure ReleaseBindInfo(const bindinfo: TBindInfo);

const
  INET_E_USE_DEFAULT_PROTOCOLHANDLER = HResult($800C0011);
  INET_E_USE_DEFAULT_SETTING         = HResult($800C0012);
  INET_E_DEFAULT_ACTION              = HResult($800C0011);
  INET_E_QUERYOPTION_UNKNOWN         = HResult($800C0013);
  INET_E_REDIRECTING                 = HResult($800C0014);

  PROTOCOLFLAG_NO_PICS_CHECK     = $00000001;

type
  [ComImport,
  GuidAttribute('79eac9ed-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetSecurityMgrSite = interface
    [PreserveSig]
    function GetWindow(out hwnd: HWnd): HResult;
    [PreserveSig]
    function EnableModeless(fEnable: BOOL): HResult;
  end;

const
  MAX_SIZE_SECURITY_ID    = 512; // bytes;

  // MapUrlToZone returns the zone index given a URL
  PUAF_DEFAULT            = $00000000;
  PUAF_NOUI               = $00000001;
  PUAF_ISFILE             = $00000002;
  PUAF_WARN_IF_DENIED     = $00000004;
  PUAF_FORCEUI_FOREGROUND = $00000008;
  PUAF_CHECK_TIFS         = $00000010;

// This is the wrapper function that most clients will use.
// It figures out the current Policy for the passed in Action,
// and puts up UI if the current Policy indicates that the user
// should be queried. It returns back the Policy which the caller
// will use to determine if the action should be allowed
// This is the wrapper function to conveniently read a custom policy.

// SetZoneMapping
//    lpszPattern: string denoting a URL pattern
//        Examples of valid patterns:
//            *://*.msn.com
//            http://*.sony.co.jp
//            *://et.msn.com
//            ftp://157.54.23.41/
//            https://localsvr
//            file:\localsvr\share
//            *://157.54.100-200.*
//        Examples of invalid patterns:
//            http://*.lcs.mit.edu
//            ftp://*
//    dwFlags: SZM_FLAGS values

  SZM_CREATE= $00000000;
  SZM_DELETE= $00000001;

type  
  [ComImport,
  GuidAttribute('79eac9ee-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetSecurityManager = interface
    [PreserveSig]
    function SetSecuritySite(Site: IInternetSecurityMgrSite): HResult;
    [PreserveSig]
    function GetSecuritySite(out Site: IInternetSecurityMgrSite): HResult;
    [PreserveSig]
    function MapUrlToZone(pwszUrl: string; out dwZone: DWORD;
      dwFlags: DWORD): HResult;
    [PreserveSig]
    function GetSecurityId(pwszUrl: string; pbSecurityId: IntPtr;
      var cbSecurityId: DWORD; dwReserved: DWORD): HResult;
    [PreserveSig]
    function ProcessUrlAction(pwszUrl: string; dwAction: DWORD;
      pPolicy: IntPtr; cbPolicy: DWORD; pContext: IntPtr; cbContext: DWORD;
      dwFlags, dwReserved: DWORD): HResult;
    [PreserveSig]
    function QueryCustomPolicy(pwszUrl: string;
      [in, MarshalAs(UnmanagedType.LPStruct)] guidKey: TGUID;
      out pPolicy: IntPtr; out cbPolicy: DWORD; pContext: IntPtr; cbContext: DWORD;
      dwReserved: DWORD): HResult;
    [PreserveSig]
    function SetZoneMapping(dwZone: DWORD; lpszPattern: string;
      dwFlags: DWORD): HResult;
    [PreserveSig]
    function GetZoneMappings(dwZone: DWORD; out enumString: IEnumString;
      dwFlags: DWORD): HResult;
  end;

  [ComImport,
  GuidAttribute('3af280b6-cb3f-11d0-891e-00c04fb6bfc4'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetHostSecurityManager = interface
    [PreserveSig]
    function GetSecurityId(pbSecurityId: IntPtr; var cbSecurityId: DWORD;
      dwReserved: DWORD): HResult;
    [PreserveSig]
    function ProcessUrlAction(dwAction: DWORD; pPolicy: IntPtr; cbPolicy: DWORD;
      pContext: IntPtr; cbContext, dwFlags, dwReserved: DWORD): HResult;
    [PreserveSig]
    function QueryCustomPolicy([in, MarshalAs(UnmanagedType.LPStruct)] guidKey: TGUID;
      out pPolicy: IntPtr; out cbPolicy: DWORD;
      pContext: IntPtr; cbContext, dwReserved: DWORD): HResult;
  end;

const
  URLACTION_MIN                                = $00001000;

  URLACTION_DOWNLOAD_MIN                       = $00001000;
  URLACTION_DOWNLOAD_SIGNED_ACTIVEX            = $00001001;
  URLACTION_DOWNLOAD_UNSIGNED_ACTIVEX          = $00001004;
  URLACTION_DOWNLOAD_CURR_MAX                  = $00001004;
  URLACTION_DOWNLOAD_MAX                       = $000011FF;

  URLACTION_ACTIVEX_MIN                        = $00001200;
  URLACTION_ACTIVEX_RUN                        = $00001200;
  URLACTION_ACTIVEX_OVERRIDE_OBJECT_SAFETY     = $00001201; // aggregate next four
  URLACTION_ACTIVEX_OVERRIDE_DATA_SAFETY       = $00001202; //
  URLACTION_ACTIVEX_OVERRIDE_SCRIPT_SAFETY     = $00001203; //
  URLACTION_SCRIPT_OVERRIDE_SAFETY             = $00001401; //
  URLACTION_ACTIVEX_CONFIRM_NOOBJECTSAFETY     = $00001204; //
  URLACTION_ACTIVEX_TREATASUNTRUSTED           = $00001205;
  URLACTION_ACTIVEX_CURR_MAX                   = $00001205;
  URLACTION_ACTIVEX_MAX                        = $000013FF;

  URLACTION_SCRIPT_MIN                         = $00001400;
  URLACTION_SCRIPT_RUN                         = $00001400;
  URLACTION_SCRIPT_JAVA_USE                    = $00001402;
  URLACTION_SCRIPT_SAFE_ACTIVEX                = $00001405;
  URLACTION_SCRIPT_CURR_MAX                    = $00001405;
  URLACTION_SCRIPT_MAX                         = $000015FF;

  URLACTION_HTML_MIN                           = $00001600;
  URLACTION_HTML_SUBMIT_FORMS                  = $00001601; // aggregate next two
  URLACTION_HTML_SUBMIT_FORMS_FROM             = $00001602; //
  URLACTION_HTML_SUBMIT_FORMS_TO               = $00001603; //
  URLACTION_HTML_FONT_DOWNLOAD                 = $00001604;
  URLACTION_HTML_JAVA_RUN                      = $00001605; // derive from Java custom policy;
  URLACTION_HTML_CURR_MAX                      = $00001605;
  URLACTION_HTML_MAX                           = $000017FF;

  URLACTION_SHELL_MIN                          = $00001800;
  URLACTION_SHELL_INSTALL_DTITEMS              = $00001800;
  URLACTION_SHELL_MOVE_OR_COPY                 = $00001802;
  URLACTION_SHELL_FILE_DOWNLOAD                = $00001803;
  URLACTION_SHELL_VERB                         = $00001804;
  URLACTION_SHELL_WEBVIEW_VERB                 = $00001805;
  URLACTION_SHELL_CURR_MAX                     = $00001805;
  URLACTION_SHELL_MAX                          = $000019ff;

  URLACTION_NETWORK_MIN                        = $00001A00;

  URLACTION_CREDENTIALS_USE                    = $00001A00;
  URLPOLICY_CREDENTIALS_SILENT_LOGON_OK        = $00000000;
  URLPOLICY_CREDENTIALS_MUST_PROMPT_USER       = $00010000;
  URLPOLICY_CREDENTIALS_CONDITIONAL_PROMPT     = $00020000;
  URLPOLICY_CREDENTIALS_ANONYMOUS_ONLY         = $00030000;

  URLACTION_AUTHENTICATE_CLIENT                = $00001A01;
  URLPOLICY_AUTHENTICATE_CLEARTEXT_OK          = $00000000;
  URLPOLICY_AUTHENTICATE_CHALLENGE_RESPONSE    = $00010000;
  URLPOLICY_AUTHENTICATE_MUTUAL_ONLY           = $00030000;

  URLACTION_NETWORK_CURR_MAX                   = $00001A01;
  URLACTION_NETWORK_MAX                        = $00001BFF;

  URLACTION_JAVA_MIN                           = $00001C00;
  URLACTION_JAVA_PERMISSIONS                   = $00001C00;
  URLPOLICY_JAVA_PROHIBIT                      = $00000000;
  URLPOLICY_JAVA_HIGH                          = $00010000;
  URLPOLICY_JAVA_MEDIUM                        = $00020000;
  URLPOLICY_JAVA_LOW                           = $00030000;
  URLPOLICY_JAVA_CUSTOM                        = $00800000;
  URLACTION_JAVA_CURR_MAX                      = $00001C00;
  URLACTION_JAVA_MAX                           = $00001CFF;

// The following Infodelivery actions should have no default policies
// in the registry.  They assume that no default policy means fall
// back to the global restriction.  If an admin sets a policy per
// zone, then it overrides the global restriction.

  URLACTION_INFODELIVERY_MIN                       = $00001D00;
  URLACTION_INFODELIVERY_NO_ADDING_CHANNELS        = $00001D00;
  URLACTION_INFODELIVERY_NO_EDITING_CHANNELS       = $00001D01;
  URLACTION_INFODELIVERY_NO_REMOVING_CHANNELS      = $00001D02;
  URLACTION_INFODELIVERY_NO_ADDING_SUBSCRIPTIONS   = $00001D03;
  URLACTION_INFODELIVERY_NO_EDITING_SUBSCRIPTIONS  = $00001D04;
  URLACTION_INFODELIVERY_NO_REMOVING_SUBSCRIPTIONS = $00001D05;
  URLACTION_INFODELIVERY_NO_CHANNEL_LOGGING        = $00001D06;
  URLACTION_INFODELIVERY_CURR_MAX                  = $00001D06;
  URLACTION_INFODELIVERY_MAX                       = $00001Dff;
  URLACTION_CHANNEL_SOFTDIST_MIN                   = $00001E00;
  URLACTION_CHANNEL_SOFTDIST_PERMISSIONS           = $00001E05;
  URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT              = $00010000;
  URLPOLICY_CHANNEL_SOFTDIST_PRECACHE              = $00020000;
  URLPOLICY_CHANNEL_SOFTDIST_AUTOINSTALL           = $00030000;
  URLACTION_CHANNEL_SOFTDIST_MAX                   = $00001EFF;

// For each action specified above the system maintains
// a set of policies for the action.
// The only policies supported currently are permissions (i.e. is something allowed)
// and logging status.
// IMPORTANT: If you are defining your own policies don't overload the meaning of the
// loword of the policy. You can use the hiword to store any policy bits which are only
// meaningful to your action.
// For an example of how to do this look at the URLPOLICY_JAVA above

// Permissions
  URLPOLICY_ALLOW                = $00;
  URLPOLICY_QUERY                = $01;
  URLPOLICY_DISALLOW             = $03;

// Notifications are not done when user already queried.
  URLPOLICY_NOTIFY_ON_ALLOW      = $10;
  URLPOLICY_NOTIFY_ON_DISALLOW   = $20;

// Logging is done regardless of whether user was queried.
  URLPOLICY_LOG_ON_ALLOW         = $40;
  URLPOLICY_LOG_ON_DISALLOW      = $80;

  URLPOLICY_MASK_PERMISSIONS     = $0f;

function GetUrlPolicyPermissions(dw: DWORD): DWORD;
function SetUrlPolicyPermissions(dw, dw2: DWORD): DWORD;

// The ordinal #'s that define the predefined zones internet explorer knows about.
// When we support user-defined zones their zone numbers should be between
// URLZONE_USER_MIN and URLZONE_USER_MAX

const  
  URLZONE_PREDEFINED_MIN =     0;
  URLZONE_LOCAL_MACHINE  =     0;
  URLZONE_INTRANET       = URLZONE_LOCAL_MACHINE + 1;
  URLZONE_TRUSTED        = URLZONE_INTRANET + 1;
  URLZONE_INTERNET       = URLZONE_TRUSTED + 1;
  URLZONE_UNTRUSTED      = URLZONE_INTERNET + 1;
  URLZONE_PREDEFINED_MAX =   999;
  URLZONE_USER_MIN       =  1000;
  URLZONE_USER_MAX       = 10000;

  URLTEMPLATE_CUSTOM         = $00000000;
  URLTEMPLATE_PREDEFINED_MIN = $00010000;
  URLTEMPLATE_LOW            = $00010000;
  URLTEMPLATE_MEDIUM         = $00011000;
  URLTEMPLATE_HIGH           = $00012000;
  URLTEMPLATE_PREDEFINED_MAX = $00020000;

  MAX_ZONE_PATH              = 260;
  MAX_ZONE_DESCRIPTION       = 200;

  ZAFLAGS_CUSTOM_EDIT            = $00000001;
  ZAFLAGS_ADD_SITES              = $00000002;
  ZAFLAGS_REQUIRE_VERIFICATION   = $00000004;
  ZAFLAGS_INCLUDE_PROXY_OVERRIDE = $00000008;
  ZAFLAGS_INCLUDE_INTRANET_SITES = $00000010;
  ZAFLAGS_NO_UI                  = $00000020;
  ZAFLAGS_SUPPORTS_VERIFICATION  = $00000040;
  ZAFLAGS_UNC_AS_INTRANET        = $00000080;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _ZONEATTRIBUTES = packed record
    cbSize: ULONG;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=260)]
    szDisplayName: array [0..260 - 1] of WideChar;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=260)]
    szDescription: array [0..200 - 1] of WideChar;
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=260)]
    szIconPath: array [0..260 - 1] of WideChar;
    dwTemplateMinLevel: DWORD;
    dwTemplateRecommended: DWORD;
    dwTemplateCurrentLevel: DWORD;
    dwFlags: DWORD;
  end;
  TZoneAttributes = _ZONEATTRIBUTES;
  ZONEATTRIBUTES = _ZONEATTRIBUTES;

// Gets the zone attributes (information in registry other than actual security
// policies associated with the zone).  Zone attributes are fixed as:
// Sets the zone attributes (information in registry other than actual security
// policies associated with the zone).  Zone attributes as above. 
// Returns S_OK or ??? if failed to write the zone attributes. 
{  Registry Flags 

    When reading, default behavior is: 
        If HKLM allows override and HKCU value exists 
            Then use HKCU value 
            Else use HKLM value 
    When writing, default behavior is same as HKCU 
        If HKLM allows override 
           Then Write to HKCU 
           Else Fail 
} 

const
  URLZONEREG_DEFAULT = 0;
  URLZONEREG_HKLM    = URLZONEREG_DEFAULT + 1;
  URLZONEREG_HKCU    = URLZONEREG_HKLM + 1;

// Gets a named custom policy associated with a zone; 
// e.g. the Java VM settings can be defined with a unique key such as 'Java'. 
// Custom policy support is intended to allow extensibility from the predefined 
// set of policies that IE4 has built in. 
//  
// pwszKey is the string name designating the custom policy.  Components are 
//   responsible for having unique names.
// ppPolicy is the callee allocated buffer for the policy byte blob; caller is
//   responsible for freeing this buffer eventually. 
// pcbPolicy is the size of the byte blob returned. 
// dwRegFlags determines how registry is accessed (see above). 
// Returns S_OK if key is found and buffer allocated; ??? if key is not found (no buffer alloced). 
// Sets a named custom policy associated with a zone;
// e.g. the Java VM settings can be defined with a unique key such as 'Java'. 
// Custom policy support is intended to allow extensibility from the predefined 
// set of policies that IE4 has built in.
//  
// pwszKey is the string name designating the custom policy.  Components are 
//   responsible for having unique names. 
// ppPolicy is the caller allocated buffer for the policy byte blob. 
// pcbPolicy is the size of the byte blob to be set. 
// dwRegFlags determines if HTCU or HKLM is set. 
// Returns S_OK or ??? if failed to write the zone custom policy. 
// Gets action policy associated with a zone, the builtin, fixed-length policies info. 
 
// dwAction is the action code for the action as defined above. 
// pPolicy is the caller allocated buffer for the policy data. 
// cbPolicy is the size of the caller allocated buffer. 
// dwRegFlags determines how registry is accessed (see above). 
// Returns S_OK if action is valid; ??? if action is not valid.

type
  [ComImport,
  GuidAttribute('79eac9ef-baf9-11ce-8c82-00aa004ba90b'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IInternetZoneManager = interface

    // Gets the zone attributes (information in registry other than actual security
    // policies associated with the zone).  Zone attributes are fixed as:
    [PreserveSig]
    function GetZoneAttributes(dwZone: DWORD;
      var ZoneAttributes: TZoneAttributes): HResult;

    // Sets the zone attributes (information in registry other than actual security
    // policies associated with the zone).  Zone attributes as above.
    // Returns S_OK or ??? if failed to write the zone attributes.
    [PreserveSig]
    function SetZoneAttributes(dwZone: DWORD;
      [in] var ZoneAttributes: TZoneAttributes): HResult;
    [PreserveSig]
    function GetZoneCustomPolicy(dwZone: DWORD;
      [in, MarshalAs(UnmanagedType.LPStruct)] guidKey: TGUID; out pPolicy: IntPtr;
      out cbPolicy: DWORD; urlZoneReg: TUrlZoneReg): HResult;
    [PreserveSig]
    function SetZoneCustomPolicy(dwZone: DWORD;
      [in, MarshalAs(UnmanagedType.LPStruct)] guidKey: TGUID; pPolicy: IntPtr;
      cbPolicy: DWORD; urlZoneReg: TUrlZoneReg): HResult;
    [PreserveSig]
    function GetZoneActionPolicy(dwZone, dwAction: DWORD; pPolicy: IntPtr;
      cbPolicy: DWORD; urlZoneReg: TUrlZoneReg): HResult;
    [PreserveSig]
    function SetZoneActionPolicy(dwZone, dwAction: DWORD; pPolicy: IntPtr;
      cbPolicy: DWORD; urlZoneReg: TUrlZoneReg): HResult;
    [PreserveSig]
    function PromptAction(dwAction: DWORD; hwndParent: HWnd; pwszUrl, pwszText: string;
      dwPromptFlags: DWORD): HResult;
    [PreserveSig]
    function LogAction(dwAction: DWORD; pwszUrl, pwszText: string;
      dwLogFlags: DWORD): HResult;
    [PreserveSig]
    function CreateZoneEnumerator(out dwEnum, dwCount: DWORD;
      dwFlags: DWORD): HResult;
    [PreserveSig]
    function GetZoneAt(dwEnum, dwIndex: DWORD; out dwZone: DWORD): HResult;
    [PreserveSig]
    function DestroyZoneEnumerator(dwEnum: DWORD): HResult;
    [PreserveSig]
    function CopyTemplatePoliciesToZone(dwTemplate, dwZone, dwReserved: DWORD): HResult;
  end;

// Creates the security manager object. The first argument is the Service provider
// to allow for delegation
function CoInternetCreateSecurityManager(SP: IServiceProvider; var SM: IInternetSecurityManager;
  dwReserved: DWORD): HResult;
function CoInternetCreateZoneManager(SP: IServiceProvider; var ZM: IInternetZoneManager;
  dwReserved: DWORD): HResult;

const
  SOFTDIST_FLAG_USAGE_EMAIL         = $00000001;
  SOFTDIST_FLAG_USAGE_PRECACHE      = $00000002;
  SOFTDIST_FLAG_USAGE_AUTOINSTALL   = $00000004;
  SOFTDIST_FLAG_DELETE_SUBSCRIPTION = $00000008;

  SOFTDIST_ADSTATE_NONE             = $00000000;
  SOFTDIST_ADSTATE_AVAILABLE        = $00000001;
  SOFTDIST_ADSTATE_DOWNLOADED       = $00000002;
  SOFTDIST_ADSTATE_INSTALLED        = $00000003;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _tagCODEBASEHOLD = packed record
    cbSize: ULONG;
    [MarshalAs(UnmanagedType.LPWStr)]
    szDistUnit: string;
    [MarshalAs(UnmanagedType.LPWStr)]
    szCodeBase: string;
    dwVersionMS: DWORD;
    dwVersionLS: DWORD;
    dwStyle: DWORD;
  end;
  TCodeBaseHold = _tagCODEBASEHOLD;
  CODEBASEHOLD = _tagCODEBASEHOLD;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _tagSOFTDISTINFO = packed record
    cbSize: ULONG;
    dwFlags: DWORD;
    dwAdState: DWORD;
    [MarshalAs(UnmanagedType.LPWStr)]
    szTitle: string;
    [MarshalAs(UnmanagedType.LPWStr)]
    szAbstract: string;
    [MarshalAs(UnmanagedType.LPWStr)]
    szHREF: string;
    dwInstalledVersionMS: DWORD;
    dwInstalledVersionLS: DWORD;
    dwUpdateVersionMS: DWORD;
    dwUpdateVersionLS: DWORD;
    dwAdvertisedVersionMS: DWORD;
    dwAdvertisedVersionLS: DWORD;
    dwReserved: DWORD;
  end;
  TSoftDistInfo = _tagSOFTDISTINFO;
  SOFTDISTINFO = _tagSOFTDISTINFO;

  [ComImport,
  GuidAttribute('B15B8DC1-C7E1-11d0-8680-00AA00BDCB71'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISoftDistExt = interface
    [PreserveSig]
    function ProcessSoftDist(szCDFURL: string; SoftDistElement: IntPtr {IXMLElement};
      var lpdsi: TSoftDistInfo): HResult;
    [PreserveSig]
    function GetFirstCodeBase([MarshalAs(UnmanagedType.LPWStr)] var szCodeBase: string;
      [in] var dwMaxSize: DWORD): HResult;
    [PreserveSig]
    function GetNextCodeBase([MarshalAs(UnmanagedType.LPWStr)] var szCodeBase: string;
      [in] var dwMaxSize: DWORD): HResult;
    [PreserveSig]
    function AsyncInstallDistributionUnit(bc: IBindCtx; pvReserved: IntPtr;
      flags: DWORD; [in] var cbh: TCodeBaseHold): HResult;
  end;

function GetSoftwareUpdateInfo(szDistUnit: string; var dsi: TSoftDistInfo): HResult;
function SetSoftwareUpdateAdvertisementState(szDistUnit: string;
  dwAdState, dwAdvertisedVersionMS, dwAdvertisedVersionLS: DWORD): HResult;

type
  [ComImport,
  GuidAttribute('69d14c80-c18e-11d0-a9ce-006097942311'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDataFilter = interface
    [PreserveSig]
    function DoEncode(dwFlags: DWORD; lInBufferSize: Longint; pbInBuffer: IntPtr;
      lOutBufferSize: Longint; pbOutBuffer: IntPtr; lInBytesAvailable: Longint;
      out lInBytesRead, lOutBytesWritten: Longint; dwReserved: DWORD): HResult;
    [PreserveSig]
    function DoDecode(dwFlags: DWORD; lInBufferSize: Longint; pbInBuffer: IntPtr;
      lOutBufferSize: Longint; pbOutBuffer: IntPtr; lInBytesAvailable: Longint;
      out lInBytesRead, lOutBytesWritten: Longint; dwReserved: DWORD): HResult;
    [PreserveSig]
    function SetEncodingLevel(dwEncLevel: DWORD): HResult;
  end;

  _tagPROTOCOLFILTERDATA = packed record
    cbSize: DWORD;
    ProtocolSink: IInternetProtocolSink;
    Protocol: IInternetProtocol;
    [MarshalAs(UnmanagedType.IUnknown)]
    Unk: TObject;
    dwFilterFlags: DWORD;
  end;
  TProtocolFilterData = _tagPROTOCOLFILTERDATA;
  PROTOCOLFILTERDATA = _tagPROTOCOLFILTERDATA;

  _tagDATAINFO = packed record
    ulTotalSize: ULONG;
    ulavrPacketSize: ULONG;
    ulConnectSpeed: ULONG;
    ulProcessorSpeed: ULONG;
  end;
  TDataInfo = _tagDATAINFO;
  DATAINFO = _tagDATAINFO;

  [ComImport,
  GuidAttribute('70bdde00-c18e-11d0-a9ce-006097942311'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEncodingFilterFactory = interface
    [PreserveSig]
    function FindBestFilter(pwzCodeIn, pwzCodeOut: string; info: TDataInfo;
      out DF: IDataFilter): HResult;
    [PreserveSig]
    function GetDefaultFilter(pwzCodeIn, pwzCodeOut: string; info: TDataInfo;
      out DF: IDataFilter): HResult;
  end;

// Logging-specific apis
function IsLoggingEnabled(pszUrl: string): BOOL;
function IsLoggingEnabledA(pszUrl: string): BOOL;
function IsLoggingEnabledW(pszUrl: string): BOOL;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _tagHIT_LOGGING_INFO = packed record
    dwStructSize: DWORD;
    [MarshalAs(UnmanagedType.LPStr)]
    lpszLoggedUrlName: string;
    StartTime: TSystemTime;
    EndTime: TSystemTime;
    [MarshalAs(UnmanagedType.LPStr)]
    lpszExtendedInfo: string;
  end;
  THitLoggingInfo = _tagHIT_LOGGING_INFO;
  HIT_LOGGING_INFO = _tagHIT_LOGGING_INFO;

function WriteHitLogging(const Logginginfo: THitLoggingInfo): BOOL;

implementation

uses
  System.Security;

const
  UrlMonLib = 'URLMON.DLL';

// Macro implementations
function GetUrlPolicyPermissions(dw: DWORD): DWORD;
begin
  Result := dw and URLPOLICY_MASK_PERMISSIONS;
end;

function SetUrlPolicyPermissions(dw, dw2: DWORD): DWORD;
begin
  dw := (dw and not (URLPOLICY_MASK_PERMISSIONS)) or dw2;
  Result := dw;
end;

[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateURLMoniker')]
function CreateURLMoniker; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetClassURL')]
function GetClassURL; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateAsyncBindCtx')]
function CreateAsyncBindCtx; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateAsyncBindCtxEx')]
function CreateAsyncBindCtxEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'MkParseDisplayNameEx')]
function MkParseDisplayNameEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegisterBindStatusCallback')]
function RegisterBindStatusCallback; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RevokeBindStatusCallback')]
function RevokeBindStatusCallback; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetClassFileOrMime')]
function GetClassFileOrMime; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'IsValidURL')]
function IsValidURL; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoGetClassObjectFromURL')]
function CoGetClassObjectFromURL; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'IsAsyncMoniker')]
function IsAsyncMoniker; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateURLBinding')]
function CreateURLBinding; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegisterMediaTypes')]
function RegisterMediaTypes; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindMediaType')]
function FindMediaType; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateFormatEnumerator')]
function CreateFormatEnumerator; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegisterFormatEnumerator')]
function RegisterFormatEnumerator; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RevokeFormatEnumerator')]
function RevokeFormatEnumerator; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegisterMediaTypeClass')]
function RegisterMediaTypeClass; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindMediaTypeClass')]
function FindMediaTypeClass; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'UrlMkSetSessionOption')]
function UrlMkSetSessionOption; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'UrlMkGetSessionOption')]
function UrlMkGetSessionOption; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'FindMimeFromData')]
function FindMimeFromData; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ObtainUserAgentString')]
function ObtainUserAgentString; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HlinkSimpleNavigateToString')]
function HlinkSimpleNavigateToString; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HlinkSimpleNavigateToMoniker')]
function HlinkSimpleNavigateToMoniker; external;

[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'URLOpenStream')]
function URLOpenStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'URLOpenStreamA')]
function URLOpenStreamA; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'URLOpenStreamW')]
function URLOpenStreamW; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'URLOpenPullStream')]
function URLOpenPullStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'URLOpenPullStreamA')]
function URLOpenPullStreamA; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'URLOpenPullStreamW')]
function URLOpenPullStreamW; external;

[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'URLDownloadToFile')]
function URLDownloadToFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'URLDownloadToFileA')]
function URLDownloadToFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'URLDownloadToFileW')]
function URLDownloadToFileW; external;

[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'URLDownloadToCacheFile')]
function URLDownloadToCacheFile; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'URLDownloadToCacheFileA')]
function URLDownloadToCacheFileA; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'URLDownloadToCacheFileW')]
function URLDownloadToCacheFileW; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'URLOpenBlockingStream')]
function URLOpenBlockingStream; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'URLOpenBlockingStreamA')]
function URLOpenBlockingStreamA; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'URLOpenBlockingStreamW')]
function URLOpenBlockingStreamW; external;

[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HlinkGoBack')]
function HlinkGoBack; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HlinkGoForward')]
function HlinkGoForward; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HlinkNavigateString')]
function HlinkNavigateString; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'HlinkNavigateMoniker')]
function HlinkNavigateMoniker; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetParseUrl')]
function CoInternetParseUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetCombineUrl')]
function CoInternetCombineUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetCompareUrl')]
function CoInternetCompareUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetGetProtocolFlags')]
function CoInternetGetProtocolFlags; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetQueryInfo')]
function CoInternetQueryInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetGetSession')]
function CoInternetGetSession; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetGetSecurityUrl')]
function CoInternetGetSecurityUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OInetParseUrl')]
function OInetParseUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OInetCombineUrl')]
function OInetCombineUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OInetCompareUrl')]
function OInetCompareUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OInetQueryInfo')]
function OInetQueryInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OInetGetSession')]
function OInetGetSession; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OInetGetProtocolFlags')]
function OInetGetProtocolFlags; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OInetGetSecurityUrl')]
function OInetGetSecurityUrl; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CopyStgMedium')]
function CopyStgMedium; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CopyBindInfo')]
function CopyBindInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ReleaseBindInfo')]
procedure ReleaseBindInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetCreateSecurityManager')]
function CoInternetCreateSecurityManager; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CoInternetCreateZoneManager')]
function CoInternetCreateZoneManager; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetSoftwareUpdateInfo')]
function GetSoftwareUpdateInfo; external;

[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'IsLoggingEnabled')]
function IsLoggingEnabled; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'IsLoggingEnabledA')]
function IsLoggingEnabledA; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'IsLoggingEnabledW')]
function IsLoggingEnabledW; external;

[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'WriteHitLogging')]
function WriteHitLogging; external;
[SuppressUnmanagedCodeSecurity, DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetSoftwareUpdateAdvertisementState')]
function SetSoftwareUpdateAdvertisementState; external;

end.
